// chatroom/src/app/api/room/message/list/route.ts
import { NextRequest, NextResponse } from 'next/server';
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

export async function GET(req: NextRequest) {
  try {
    const { searchParams } = new URL(req.url);
    const roomId = searchParams.get('roomId');
    
    if (!roomId) {
      return NextResponse.json({ 
        code: 1, 
        message: '缺少 roomId 参数' 
      }, { status: 400 });
    }

    const messages = await prisma.message.findMany({
      where: { roomId: Number(roomId) },
      orderBy: { createdAt: 'asc' },
    });

    const formattedMessages = messages.map(msg => ({
      messageId: msg.id,
      roomId: msg.roomId,
      sender: msg.sender,
      content: msg.content,
      time: msg.createdAt.getTime(),
    }));

    return NextResponse.json({ 
      code: 0, 
      data: { messages: formattedMessages } 
    });
  } catch (error) {
    console.error('获取消息列表失败:', error);
    return NextResponse.json({ 
      code: 1, 
      message: '获取消息失败' 
    }, { status: 500 });
  }
}