// src/app/api/room/message/getUpdate/route.ts
import { NextRequest, NextResponse } from 'next/server';
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

export async function GET(req: NextRequest) {
  try {
    const { searchParams } = new URL(req.url);
    const roomId = searchParams.get('roomId');
    const sinceMessageId = searchParams.get('sinceMessageId');

    if (!roomId || !sinceMessageId) {
      return NextResponse.json({ code: 1, message: '缺少参数' }, { status: 400 });
    }

    const list = await prisma.message.findMany({
      where: { roomId: Number(roomId), id: { gt: Number(sinceMessageId) } },
      orderBy: { createdAt: 'asc' },
    });

    const messages = list.map((m) => ({
      messageId: m.id,
      roomId: m.roomId,
      sender: m.sender,
      content: m.content,
      time: m.createdAt.getTime(),
    }));

    return NextResponse.json({ code: 0, data: { messages } });
  } catch (e) {
    console.error('增量拉取失败:', e);
    return NextResponse.json({ code: 1, message: '服务器错误' }, { status: 500 });
  }
}