//src/middleware.ts
import { NextResponse } from 'next/server';
import type { NextRequest } from 'next/server';

// middleware.ts - 简化版本，因为jwt需要在API路由内部验证
export function middleware(req: NextRequest) {
  // 中间件不验证JWT（因为Edge Runtime不支持jsonwebtoken包）
  // JWT验证移到各个API路由内部处理
  return NextResponse.next();
}

export const config = {
  matcher: '/api/:path*'
}