// chatroom/src/app/login/page.tsx
'use client';
import { useState } from 'react';
import { useRouter } from 'next/navigation';

export default function LoginPage() {
  const [username, setU] = useState('');
  const [password, setP] = useState('');
  const router = useRouter();

  const login = async () => {
    const res = await fetch('/api/auth/login', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ username, password }),
    });
    const json = await res.json();
    if (json.code !== 0) return alert(json.message);

    localStorage.setItem('token', json.data.accessToken);
    localStorage.setItem('nickname', username);
    router.push('/setname'); // 或直接 /chat
  };

  return (
    <main style={{ padding: '2rem', textAlign: 'center' }}>
      <h1>登录</h1>
      <input placeholder="用户名" value={username} onChange={e => setU(e.target.value)} /><br/>
      <input placeholder="密码" type="password" value={password} onChange={e => setP(e.target.value)} /><br/>
      <button onClick={login}>登录</button>
      <p>没账号？<a href="/signup">去注册</a></p>
    </main>
  );
}