// chatroom/src/app/page.tsx
// 导入Next.js的Link组件（客户端导航，比<a>标签性能更好）
import Link from 'next/link';
// 导入CSS模块
import styles from './page.module.css';

// 默认导出的首页组件
export default function Home() {
  return (
    <main className={styles.container}>
      {/* 标题部分 */}
      <h1 className={styles.title}>欢迎来到JYCHATROOM</h1>
      
      {/* 按钮容器 */}
      <div className={styles.buttonGroup}>
        {/* 跳转到设置页的按钮 */}
        <Link href="/setname" className={styles.button}>
          设置昵称
        </Link>
        
        {/* 跳转到聊天室的按钮 */}
        <Link href="/greet" className={styles.button}>
          进入聊天室
        </Link>

        <Link href="/login" className={styles.button}>
          登录
        </Link>
      </div>
    </main>
  );
}
