// chatroom/src/app/greet/page.tsx
'use client';

import { useEffect, useState } from 'react';
import { useRouter } from 'next/navigation';
import './greet.css';

export default function ChatPage() {
  const [nickname, setNickname] = useState('');
  const router = useRouter();

  useEffect(() => {
    const savedNickname = localStorage.getItem('nickname');
    if (!savedNickname) {
      alert('请先设置昵称');
      router.push('/nickname');
    } else {
      setNickname(savedNickname);
    }
  }, []);
    useEffect(() => {
    setTimeout(() => {
      // 5秒后跳转到目标页面
      router.push('/chat')
    }, 3000); // 5000毫秒（5秒）后执行
  }, []); // 空依赖数组表示这个effect只会在组件挂载时执行一次

  return (
    <div>
        <h1 className='{styles.title}'>欢迎，{nickname}！</h1>
            <p>这个页面将在3秒后自动跳转聊天页面</p>
    </div>
  );
}