// chatroom/src/app/api/room/delete/route.ts

import { NextRequest, NextResponse } from 'next/server';
import { PrismaClient } from '@prisma/client';
import jwt from 'jsonwebtoken';

const prisma = new PrismaClient();
const JWT_SECRET = process.env.JWT_SECRET || 'dev_secret';

export async function POST(req: NextRequest) {
  try {
    const authHeader = req.headers.get('authorization');
    if (!authHeader?.startsWith('Bearer ')) {
      return NextResponse.json({ code: 1, message: '未登录' }, { status: 401 });
    }

    const token = authHeader.slice(7);
    
    try {
      const decoded = jwt.verify(token, JWT_SECRET) as any;
      console.log('删除操作用户:', decoded.username);
    } catch (error) {
      return NextResponse.json({ code: 1, message: 'token 无效' }, { status: 401 });
    }

    const { roomId } = await req.json();
    if (!roomId) {
      return NextResponse.json({ code: 1, message: '缺少 roomId' }, { status: 400 });
    }

    console.log('删除房间 ID:', roomId);

    // 先检查房间是否存在
    const room = await prisma.room.findUnique({
      where: { id: Number(roomId) }
    });

    if (!room) {
      return NextResponse.json({ code: 1, message: '房间不存在' }, { status: 404 });
    }

    // 删除房间内的所有消息
    await prisma.message.deleteMany({
      where: { roomId: Number(roomId) }
    });

    // 删除房间
    await prisma.room.delete({
      where: { id: Number(roomId) }
    });

    console.log('房间删除成功');
    return NextResponse.json({ code: 0, message: '删除成功' });
  } catch (error) {
    console.error('删除房间错误:', error);
    return NextResponse.json({ code: 1, message: '删除失败' }, { status: 500 });
  }
}