// chatroom/src/app/setname/page.tsx
'use client';

import { useState, useEffect } from 'react';
import { useRouter } from 'next/navigation';
import styles from './page.module.css';

export default function SetnamePage() {
  const [nickname, setNickname] = useState('');
  const [currentNickname, setCurrentNickname] = useState('');
  const router = useRouter();

  useEffect(() => {
    // 检查是否已有昵称
    const saved = localStorage.getItem('nickname');
    if (saved) {
      setCurrentNickname(saved);
      setNickname(saved);
    }
  }, []);

  const handleEnterChat = () => {
    if (!nickname.trim()) {
      alert('请输入昵称');
      return;
    }

    // 将昵称保存在 localStorage 中
    localStorage.setItem('nickname', nickname);

    // 跳转到欢迎页面
    router.push('/greet');
  };

  const handleKeyPress = (e: React.KeyboardEvent<HTMLInputElement>) => {
    if (e.key === 'Enter') {
      handleEnterChat();
    }
  };

  return (
    <div className={styles.container}>
      <div className={styles.card}>
        <div className={styles.emoji}>👋</div>
        <h1 className={styles.title}>设置昵称</h1>
        <p className={styles.subtitle}>
          {currentNickname 
            ? `当前昵称：${currentNickname}` 
            : '请输入一个昵称来开始聊天'}
        </p>
        
        <input
          className={styles.input}
          type="text"
          placeholder="请输入你的昵称"
          value={nickname}
          onChange={(e) => setNickname(e.target.value)}
          onKeyPress={handleKeyPress}
          maxLength={20}
        />
        
        <button
          className={styles.button}
          onClick={handleEnterChat}
          disabled={!nickname.trim()}
        >
          进入聊天室
        </button>
      </div>
    </div>
  );
}