// chatroom/src/app/api/auth/signup/route.ts
import { NextRequest, NextResponse } from 'next/server';
import bcrypt from 'bcryptjs';
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

export async function POST(req: NextRequest) {
  try {
    const { username, password } = await req.json();
    if (!username || !password)
      return NextResponse.json({ code: 1, message: '参数缺失' }, { status: 400 });

    const exists = await prisma.user.findUnique({ where: { username } });
    if (exists)
      return NextResponse.json({ code: 1, message: '用户名已存在' }, { status: 400 });

    const hashed = await bcrypt.hash(password, 10);
    await prisma.user.create({ data: { username, password: hashed } });
    return NextResponse.json({ code: 0, message: '注册成功' });
  } catch {
    return NextResponse.json({ code: 1, message: '服务器错误' }, { status: 500 });
  }
}