// chatroom/src/app/signup/page.tsx
'use client';

import { useState } from 'react';
import { useRouter } from 'next/navigation';
import styles from './page.module.css';

export default function SignupPage() {
  const [username, setU] = useState('');
  const [password, setP] = useState('');
  const [confirmPwd, setC] = useState('');
  const [error, setError] = useState('');
  const router = useRouter();

  const signup = async () => {
    setError('');
    
    if (!username.trim() || !password.trim()) {
      setError('用户名和密码不能为空');
      return;
    }
    
    if (password !== confirmPwd) {
      setError('两次密码不一致');
      return;
    }

    const res = await fetch('/api/auth/signup', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ username, password }),
    });
    
    const json = await res.json();
    if (json.code !== 0) {
      setError(json.message);
      return;
    }

    alert('注册成功！请登录');
    router.push('/login');
  };

  return (
    <div className={styles.container}>
      <div className={styles.card}>
        <h1 className={styles.title}>注册账号</h1>
        
        <input 
          className={styles.input}
          placeholder="用户名" 
          value={username} 
          onChange={e => setU(e.target.value)} 
        />
        
        <input 
          className={styles.input}
          placeholder="密码" 
          type="password" 
          value={password} 
          onChange={e => setP(e.target.value)} 
        />
        
        <input 
          className={styles.input}
          placeholder="确认密码" 
          type="password" 
          value={confirmPwd} 
          onChange={e => setC(e.target.value)} 
        />
        
        {error && <div className={styles.error}>{error}</div>}
        
        <button className={styles.button} onClick={signup}>
          注册
        </button>
        
        <p className={styles.footer}>
          已有账号？<a href="/login" className={styles.link}>去登录</a>
        </p>
      </div>
    </div>
  );
}