// chatroom/src/app/api/room/message/getUpdate/route.ts
import { NextRequest, NextResponse } from 'next/server';
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

export async function GET(req: NextRequest) {
  try {
    const { searchParams } = new URL(req.url);
    const roomId = searchParams.get('roomId');
    const sinceMessageId = searchParams.get('sinceMessageId');
    
    if (!roomId) {
      return NextResponse.json({ 
        code: 1, 
        message: '缺少 roomId 参数' 
      }, { status: 400 });
    }

    if (!sinceMessageId) {
      return NextResponse.json({ 
        code: 1, 
        message: '缺少 sinceMessageId 参数' 
      }, { status: 400 });
    }

    // 获取指定消息ID之后的所有新消息
    const messages = await prisma.message.findMany({
      where: { 
        roomId: Number(roomId),
        id: { 
          gt: Number(sinceMessageId) // greater than - 大于指定的消息ID
        }
      },
      orderBy: { createdAt: 'asc' },
    });

    const formattedMessages = messages.map(msg => ({
      messageId: msg.id,
      roomId: msg.roomId,
      sender: msg.sender,
      content: msg.content,
      time: msg.createdAt.getTime(),
    }));

    return NextResponse.json({ 
      code: 0, 
      data: { messages: formattedMessages } 
    });
  } catch (error) {
    console.error('获取增量消息失败:', error);
    return NextResponse.json({ 
      code: 1, 
      message: '获取消息失败' 
    }, { status: 500 });
  }
}