// chatroom/src/app/api/message/add/route.ts
import { NextRequest, NextResponse } from 'next/server';
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

export async function POST(req: NextRequest) {
  try {
    const { roomId, content, sender } = await req.json();
    
    if (!roomId || !content || !sender) {
      return NextResponse.json({ 
        code: 1, 
        message: '参数缺失' 
      }, { status: 400 });
    }

    const message = await prisma.message.create({
      data: { 
        roomId: Number(roomId), 
        content, 
        sender 
      },
    });

    return NextResponse.json({ 
      code: 0, 
      data: null,
      message: '发送成功' 
    });
  } catch (error) {
    console.error('发送消息失败:', error);
    return NextResponse.json({ 
      code: 1, 
      message: '发送消息失败' 
    }, { status: 500 });
  }
}