
# INTERN PROJECT FRONTEND

## 前端编辑方式

### 修改方式

使用 npm run dev 即可实时跟随修改。

主要逻辑在 App.tsx 当中。

如果需要修改逻辑，直接改正 App.tsx 的各个部分即可。

### 打包方式

调用 npm run build 即可打包。

打包后的文件在dist文件夹。

如果打包之后的html打开不显示，可以：
 - 把生成后的index.html打开
 - 把js和css移至与html同目录下面
 - 把html当中引用js和css的路径修正
 - 去掉crossorigin字样
 - 把script段从head移到body，并去掉type = "module"

## 后端对接

在app.tsx当中硬编码了使用8080端口。可以在其中修改到实际使用的端口上面。

后端对接部分与接口文档一致。具体内容如下：

设后端正确配置后，在8080端口上打开了后端服务（http://localhost:8080）。

### 获取评论：

URL： 
- 部分获取： http://localhost:8080/comment/get?page={待请求的页码，从1开始计数}&size={每页大小}
- 获取全部： http://localhost:8080/comment/get?size=-1

方法：GET

header：无需

body： 无需

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": 
    {
        "total": int, //评论的总数，无论请求参数是什么
        "comments": 
        [
            {
                "id": int, // 评论ID
                "name": "string", // 评论者名字
                "content": "string", // 评论内容
            }
        ]
    }
}
```

### 添加评论：

URL： http://localhost:8080/comment/add

方法：POST

header：
```json
 {"Content-Type": "application/json"}
```

body： 
```json
{
    "name": "string", // 评论者名字
    "content": "string" // 评论内容
}
```

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": 
    {
        "id": int, // 评论ID
        "name": "string", // 评论者名字
        "content": "string" // 评论内容
    }
}
```

### 删除评论：

URL： http://localhost:8080/comment/delete?id={待删除的评论id}

方法：POST

header：无需

body： 无需

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": null
}
```

