
# INTERN PROJECT BACKEND

## 后端生成方式

### 依赖项

go编译器的版本应该至少需要1.14以上（也可能其实需要更高）

本人使用的是1.24.3版本的编译器。

依赖项目已经写在仓库当中的go.mod文件里面。

具体的依赖包括：

标准库：略

外部库：
- gorm.io/driver/sqlite
- gorm.io/gorm

安装外部库的脚本：
```sh
go get -u gorm.io/gorm
go get -u gorm.io/driver/sqlite
```

### 生成前的准备

有必要的话提前安装依赖（可能需要翻墙）

打开CGO：
```sh
go env -w CGO_ENABLED=1
```
需要确保CGO开启，且PATH环境变量当中能找到64位的GCC。

检查能否找到GCC，可以在控制台当中输入：
```sh
gcc --version
```
如果有来自gcc的输出，则说明可用。请保证找到的GCC是64位的。

另外，如果没有gcc，请自行安装gcc。

在windows系统下的话，可以选用[tdm-gcc](https://github.com/jmeubank/tdm-gcc/releases)。

如果上述检查通过，但go编译器仍返回找不到gcc的话，请重启shell。

### 生成指令

在本地的项目文件夹里面运行下述指令即可。
```sh
go build
```


## 参数配置与启动

设生成好的exe文件为BackEnd.exe。

参数配置在BackEnd.exe同目录的Config.json当中配置；
仓库里面给出了示例Config.json。

json的内容：
```json
{
    "serverPort": "8080",
    "dbPath": "example.db"
}
```

8080是前端监听的端口；
example.db是存储评论的数据库。

Config.json和example.db在仓库的Example目录下。

示例的db文件是空的。

使用时请将两个文件放在编译好的exe同目录下，启动BackEnd.exe来启动后端。

## 前端对接

前端对接部分与接口文档一致。具体内容如下：

设后端正确配置后，在8080端口上打开了后端服务（http://localhost:8080）。

### 获取评论：

URL： 
- 部分获取： http://localhost:8080/comment/get?page={待请求的页码，从1开始计数}&size={每页大小}
- 获取全部： http://localhost:8080/comment/get?size=-1

方法：GET

header：无需

body： 无需

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": 
    {
        "total": int, //评论的总数，无论请求参数是什么
        "comments": 
        [
            {
                "id": int, // 评论ID
                "name": "string", // 评论者名字
                "content": "string", // 评论内容
            }
        ]
    }
}
```

### 添加评论：

URL： http://localhost:8080/comment/add

方法：POST

header：
```json
 {"Content-Type": "application/json"}
```

body： 
```json
{
    "name": "string", // 评论者名字
    "content": "string" // 评论内容
}
```

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": 
    {
        "id": int, // 评论ID
        "name": "string", // 评论者名字
        "content": "string" // 评论内容
    }
}
```

### 删除评论：

URL： http://localhost:8080/comment/delete?id={待删除的评论id}

方法：POST

header：无需

body： 无需

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": null
}
```