package db


import (
        "log"
        "gorm.io/driver/sqlite"
        "gorm.io/gorm"
		"sync"
)

type Comment struct {
	ID      int    `json:"id" gorm:"primaryKey;autoIncrement"` // 评论ID
	Name    string `json:"name" gorm:"type:text;not null"` // 评论者名字
	Content string `json:"content" gorm:"type:text;not null"` // 评论内容
}

var (
	DB   *gorm.DB
	once sync.Once
)

func InitDB(dbPath string) {

	once.Do(func() {
		var err error
		DB, err = gorm.Open(sqlite.Open(dbPath), &gorm.Config{})
		if err != nil {
			log.Fatalf("Failed to open database: %v", err)
		}

		err = DB.AutoMigrate(&Comment{})
		if err != nil {
			log.Fatalf("Failed to migrate database: %v", err)
		}

		log.Printf("Database %s initialized successfully.", dbPath)
	})

}

func CloseDB() {
	if DB != nil {
		sqlDB, err := DB.DB()
		if err != nil {
			log.Fatalf("Failed to get database connection: %v", err)
			return
		}
		sqlDB.Close()
	}
	log.Println("Database closed successfully.")
}