package main


import (
	"log"
	"os"
	"encoding/json"
	"os/signal"
	db "BackEnd/db"
)

var (
	serverPort string
	dbPath     string
)

type Config struct {
	ServerPort string `json:"serverPort"` 
	DbPath     string `json:"dbPath"`     
}


func readConfig(filePath string) (*Config, error) {
	file, err := os.Open(filePath)
	if err != nil {
		return nil, err
	}
	defer file.Close()

	var config Config
	decoder := json.NewDecoder(file)
	if err := decoder.Decode(&config); err != nil {
		return nil, err
	}

	return &config, nil
}

func loadConfig() {
	config, err := readConfig("config.json")
	if err != nil {
		log.Fatalf("Failed to read config file: %v", err)
	}
	if config.ServerPort != "" {
		serverPort = config.ServerPort
	}
	if config.DbPath != "" {
		dbPath = config.DbPath
	}
	log.Printf("Loaded configuration: ServerPort=%s, DbPath=%s", serverPort, dbPath)
}


func main() {

	log.Println("INTERN PROJECT - COMMENT SERVICE")
	log.Println("Press Ctrl+C to exit")

	loadConfig()
	db.InitDB(dbPath)

	quit := make(chan os.Signal, 1)
	signal.Notify(quit, os.Interrupt)

	go func() {
        <-quit
        log.Println("Shutting down server...")
		db.CloseDB()
		os.Exit(0)
	}()
	
	initServer(serverPort)
}