
# INTERN PROJECT BACKEND

## 后端生成方式

## 参数配置与启动

设生成好的exe文件为BackEnd.exe。

参数配置在BackEnd.exe同目录的Config.json当中配置；
仓库里面给出了示例Config.json。

json的内容：
```json
{
    "serverPort": "8080",
    "dbPath": "example.db"
}
```

8080是前端监听的端口；
example.db是存储评论的数据库。

Config.json和example.db在仓库的Example目录下。

示例的db文件是空的。

使用时请将两个文件放在编译好的exe同目录下，启动BackEnd.exe来启动后端。

## 前端对接

前端对接部分与接口文档一致。具体内容如下：

设后端正确配置后，在8080端口上打开了后端服务（http://localhost:8080）。

### 获取评论：

URL： 
    部分获取： http://localhost:8080/comment/get?page={待请求的页码，从1开始计数}&size={每页大小}
    获取全部： http://localhost:8080/comment/get?size=-1

方法：GET

header：无需

body： 无需

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": 
    {
        "total": int, //评论的总数，无论请求参数是什么
        "comments": 
        [
            {
                "id": int, // 评论ID
                "name": "string", // 评论者名字
                "content": "string", // 评论内容
            }
        ]
    }
}
```

### 添加评论：

URL： http://localhost:8080/comment/add

方法：POST

header：
```json
 {"Content-Type": "application/json"}
```

body： 
```json
{
    "name": "string", // 评论者名字
    "content": "string" // 评论内容
}
```

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": 
    {
        "id": int, // 评论ID
        "name": "string", // 评论者名字
        "content": "string" // 评论内容
    }
}
```

### 删除评论：

URL： http://localhost:8080/comment/delete?id={待删除的评论id}

方法：POST

header：无需

body： 无需

后端返回的response：
```json
{
    "code": 0, // 0表示成功，其他表示失败
    "msg": "success", // 返回信息
    "data": null
}
```