package db


import (
        //"fmt"
        "log"
        //"gorm.io/driver/sqlite"
        "gorm.io/gorm"
)

type Comment struct {
	ID      int    `json:"id" gorm:"primaryKey;autoIncrement"` // 评论ID
	Name    string `json:"name" gorm:"not null"` // 评论者名字
	Content string `json:"content" gorm:"not null"` // 评论内容
}

var (
	DB   *gorm.DB
	//once sync.Once
)

func InitDB(dbPath string) {
	//TODO
	AddComment("Alice", "First comment!")
	AddComment("Bob", "Great work!")

	log.Println("Database initialized successfully.")
}

func CloseDB() {
	//TODO
	log.Println("Database closed successfully.")
}

/*

func InitDB(dbPath string) {
	once.Do(func() {
		var err error
		DB, err = gorm.Open(sqlite.Open(dbPath), &gorm.Config{})
		if err != nil {
			log.Fatalf("Failed to open database: %v", err)
		}

		// 创建评论表
		createTable := `
		CREATE TABLE IF NOT EXISTS comments (
			id INTEGER PRIMARY KEY AUTOINCREMENT,
			name TEXT NOT NULL,
			content TEXT NOT NULL,
			created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
		);`

		if err := DB.Exec(createTable).Error; err != nil {
			log.Fatalf("Failed to create table: %v", err)
		}

		log.Println("Database initialized successfully")
	})
}

// 关闭数据库连接
func CloseDB() {
	if DB != nil {
		DB.Close()
	}
}

*/