package db

import (
	"sync"
)

var (
	mutex     = &sync.RWMutex{}
	comments  []Comment          // 内存存储的评论列表
	incrementID int = 1          // 自增ID计数器
)

// GetComments 返回当前请求的评论列表
func GetComments() []Comment {
	mutex.RLock()
	defer mutex.RUnlock()
	return comments
}

func GetCommentsSlice(Begin int, End int) []Comment {
	mutex.RLock()
	defer mutex.RUnlock()
	if Begin < 0 || End > len(comments) || Begin > End {
		return []Comment{}
	}
	return comments[Begin:End]
}

func GetCommentCount() int {
	mutex.RLock()
	defer mutex.RUnlock()
	return len(comments)
}

func AddComment(Name string, Content string) Comment {
	mutex.Lock()
	defer mutex.Unlock()

	newComment := Comment{
		ID:      incrementID,
		Name:    Name,
		Content: Content,
	}
	incrementID++
	comments = append(comments, newComment)

	return newComment
}

func DeleteComment(Id int) bool {
	mutex.Lock()         // 写锁定
	defer mutex.Unlock() // 函数返回时解锁

	// 查找并删除评论
	found := false
	for i, comment := range comments {
		if comment.ID == Id {
			// 从切片中删除元素
			comments = append(comments[:i], comments[i+1:]...)
			found = true
			break
		}
	}
	return found
}