package main


import (
	"log"
	"os"
	"os/signal"
	db "BackEnd/db"
)



func main() {

	log.Println("INTERN PROJECT - COMMENT SERVICE")
	log.Println("Press Ctrl+C to exit")

	db.InitDB("./comments.db")

	quit := make(chan os.Signal, 1)
	signal.Notify(quit, os.Interrupt)

	go func() {
        <-quit
        log.Println("Shutting down server...")
		db.CloseDB()
        os.Exit(0)
    }()
	
	initServer()
}