import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/room/list
- method: GET
- argument: null
- response:
interface RoomListRes {
    rooms: RoomPreviewInfo[];
}
*/
export async function GET(req: NextRequest) : Promise<NextResponse<Ty.BackendResponse<Ty.RoomListResEx | null>>> {
    const cookieData = await Db.VerifyCookie(req.cookies);
    if('code' in cookieData) return NextResponse.json(cookieData);

    const response = await Db.GetRoomList(cookieData.userToken);
    return NextResponse.json(response);
}