'use client'
import { useEffect, useState } from 'react';
import { useRoom } from './room-context'

export default function ConfirmModalProvider() {

    const { 
        showCreateModal, 
        setShowCreateModal,
        newRoomName, 
        setNewRoomName, 
        showErrorModal,
        setShowErrorModal,
        afterErrorModalEvent,
        setAfterErrorModalEvent,
        errorModalMsg,
        triggerCreateRoom } = useRoom();

    const [createPending, setCreatePending] = useState(false);

    useEffect(() => {
        setCreatePending(false);
        if (showCreateModal) {
            setNewRoomName('');
        }
    }, [showCreateModal, setNewRoomName]);

    const clearErrorModal = () => {
        setShowErrorModal(false);
        afterErrorModalEvent?.();
        setAfterErrorModalEvent(null);
    }

    const handleCreateRoom = (pending : boolean) => {
        if(pending)return;
        setCreatePending(true);
        triggerCreateRoom();
    }

    return (
        <>
            {showCreateModal && 
            <div
            className="fixed inset-0 bg-black/40 flex items-center justify-center z-50"
            onClick={() => setShowCreateModal(false)}
            >
                <div
                className="bg-white p-8 rounded shadow-lg min-w-[300px]"
                onClick={(e) => e.stopPropagation()}
                >
                <h2 className="text-lg mb-2">新建房间</h2>
                <input
                    className="border px-3 py-2 mb-3 w-full"
                    placeholder="房间名称"
                    value={newRoomName}
                    onChange={(e) => setNewRoomName(e.target.value)}
                />
                <div className="flex justify-end space-x-2">
                    <button
                    className="bg-gray-200 px-4 py-2 rounded hover:bg-gray-300 active:bg-gray-400"
                    onClick={() => setShowCreateModal(false)}
                    >
                    取消
                    </button>
                    <button
                    className={
                        createPending ? 
                        "bg-gray-300 text-gray-500 px-4 py-2 rounded cursor-not-allowed" :
                        "bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600 active:bg-blue-700"
                    }
                    onClick={() => handleCreateRoom(createPending)}
                    >
                    确定
                    </button>
                </div>
                </div>
            </div>
            }
            {showErrorModal &&
            <div
            className="fixed inset-0 bg-black/40 flex items-center justify-center z-50 "
            onClick={() => clearErrorModal()}
            >
                <div
                className="bg-white p-8 rounded shadow-lg min-w-[300px]"
                onClick={(e) => e.stopPropagation()}
                >
                <h2 className="text-lg mb-2">错误</h2>
                <p className='p-1'>{errorModalMsg}</p>
                <div className="flex justify-end space-x-2">
                    <button
                    className="bg-gray-300 px-4 py-2 mt-2 rounded hover:bg-gray-400 active:bg-gray-500"
                    onClick={() => clearErrorModal()}
                    >
                    关闭
                    </button>
                </div>
                </div>
            </div>
            }
        </>
    );
}