import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';
import * as Auth from '../../login-interface';

/*
- url: /api/auth/loggedIn
- method: POST
- Read & Check Cookie
*/
export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Auth.LoggedInResult | null>>> {

    const cookieData = await Db.VerifyCookie(req.cookies)
    if('code' in cookieData)return NextResponse.json(cookieData);

    const argsCheck = Auth.LoggedInArgsSchema.safeParse(await req.json());
    if (!argsCheck.success) return Db.IncorrectArgumentResponse(argsCheck.error);

    const { user } = argsCheck.data;
    const result = await Db.CheckLoggedIn(cookieData.authToken, user);

    //invalidUserErrorCode
    //reloginErrorCode
    //incorrectUserName
    const res = NextResponse.json(result);
    if (result.code === Auth.invalidUserErrorCode || result.code === Auth.reloginErrorCode) {
        res.cookies.set('userToken', '', { maxAge: 0, path: '/' });
        res.cookies.set('authToken', '', { maxAge: 0, path: '/' });
    }

    return res;
}