'use client'
import { useState, useEffect } from 'react'
import * as Ty from './interface'

export default function RoomListProvider() {

    const [roomsLoading, setRoomsLoading] = useState<boolean>(false)
    const [roomsError, setRoomsError] = useState<string>('')
    const [rooms, setRooms] = useState<Ty.RoomPreviewInfo[]>([])


    /*
    - url: /api/room/list
    - method: GET
    - argument: null
    - response:
    interface RoomListRes {
        rooms: RoomPreviewInfo[];
    }
    */
    const getRooms = async () => {
        setRoomsLoading(true)
        setRoomsError('')
        try {
        const res = await fetch(Ty.urlPrefix + '/api/room/list', {
            method: 'GET',
        });
        if (!res.ok) {
            throw new Error('无法获取房间列表，错误码：' + res.status);
        }

        const data: Ty.BackendResponse<Ty.RoomListRes> = await res.json();

        if (data.code !== 0) {
            throw new Error('无法获取房间列表，错误信息：' + data.message);
        }

        setRooms(data.data.rooms);

        } catch (error) {
        console.error('房间列表获取失败:', error);
        setRoomsError(error.message);
        } finally {
        setRoomsLoading(false);
        }
    }

    useEffect(() => {
        getRooms();

        const interval = setInterval(() => {
        getRooms();
        }, 1000); // 1秒

        // 组件卸载时清除定时器
        return () => {
        clearInterval(interval)
        }
    }, []);

    return (
      <div className="room-container">
        <ul className="mb-2">
          {rooms && rooms.map((room) => (
                <li key={room.roomId}>
                <h3>{room.roomName} (ID: {room.roomId})</h3>
                {room.lastMessage ? (
                  <p>Last message from {room.lastMessage.sender}: {room.lastMessage.content}</p>
                ) : (
                  <p>No messages yet.</p>
                )}
              </li>
            ))
          }
        </ul>
      </div>
  );
}