import * as Ty from './interface'
import RoomListProvider from './room-list';

export default function Home() {
  return (
    <div className="bg-gray-100">
      <div className="flex h-screen">
        <div className="w-1/4 bg-white p-4 overflow-y-auto">
          <h2 className="text-lg font-bold mb-4">房间列表</h2>
          <RoomListProvider />
        </div>
      
        <div className="w-3/4 bg-gray-100 p-4">
              {/* 聊天房间名称 */}
              <div className="bg-white p-4 mb-4">
                  <h2 className="text-lg font-bold">聊天房间名称</h2>
              </div>

              {/* 历史消息列表 */}
              <div className="bg-white p-4 overflow-y-auto h-3/5">
                  <div className="bg-gray-100 h-full">
                    {/* 消息项 */}
                    <div className="mb-2">消息1</div>
                    <div className="mb-2">消息2</div>
                    <div className="mb-2">消息3</div>
                  </div>
              </div>

              <div className="bg-white p-4">
                  <textarea className="w-full resize-none" rows={4} placeholder="输入消息..."></textarea>
                  <button className="bg-blue-500 text-white py-2 px-4 mt-2 w-full hover:bg-blue-600 active:bg-blue-700">
                    发送
                  </button>
              </div>
          </div>
        </div>
    </div>
    
  );
}
