import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';
import * as Auth from '../../login-interface';

/*
- url: /api/auth/login
- method: POST
- Set Cookie
*/
export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Auth.LoginResult | null>>> {
    const result = Auth.authArgsSchema.safeParse(await req.json());
    if (!result.success) {
        return Db.MakeError('无效的请求参数', 114514, 400);
    }

    const Args: Auth.AuthArgs = result.data;
    Args.userIP = req.headers.get('x-forwarded-for') || null;

    const loginResult = await Db.Login(Args);

    const res = NextResponse.json(loginResult);

    if(loginResult.data)
    {
        res.cookies.set('userToken', loginResult.data.cookie.userToken, { path: '/' });
        res.cookies.set('authToken', loginResult.data.cookie.authToken, { path: '/' });
    }

    return res;
}