'use client'

import { useEffect } from 'react';
import { redirect } from 'next/navigation';
import { useRoom } from './room-context'
import { useLocalBackend } from '../interface';

function UsernameCheck_External() {
  const { username } = useRoom()
  useEffect(() => {
    if (!username) {
      redirect('/'); 
    }
  }, [username]);

  if (!username) return null;

  return null;
}

function UsernameCheck_Local() {
  //URL /api/auth/logged
  //TODO
  return null;
}

const UsernameCheckFn = useLocalBackend ? UsernameCheck_Local : UsernameCheck_External;

export default function UsernameCheck() {
  UsernameCheckFn();
  return null;
}