'use client'
import { useEffect } from 'react';
import { useRoom } from './room-context'
import { after } from 'node:test';
import { set } from 'zod';

export default function ConfirmModalProvider() {

    const { 
        showCreateModal, 
        setShowCreateModal,
        newRoomName, 
        setNewRoomName, 
        showErrorModal,
        setShowErrorModal,
        afterErrorModalEvent,
        setAfterErrorModalEvent,
        errorModalMsg,
        triggerCreateRoom } = useRoom();

    useEffect(() => {
        if (showCreateModal) {
            setNewRoomName('');
        }
    }, [showCreateModal, setNewRoomName]);

    const clearErrorModal = () => {
        setShowErrorModal(false);
        afterErrorModalEvent?.();
        setAfterErrorModalEvent(null);
    }

    return (
        <>
            {showCreateModal && 
            <div
            className="fixed inset-0 bg-black/40 flex items-center justify-center z-50"
            onClick={() => setShowCreateModal(false)}
            >
                <div
                className="bg-white p-8 rounded shadow-lg min-w-[300px]"
                onClick={(e) => e.stopPropagation()}
                >
                <h2 className="text-lg mb-2">新建房间</h2>
                <input
                    className="border px-3 py-2 mb-3 w-full"
                    placeholder="房间名称"
                    value={newRoomName}
                    onChange={(e) => setNewRoomName(e.target.value)}
                />
                <div className="flex justify-end space-x-2">
                    <button
                    className="bg-gray-300 px-4 py-2 rounded"
                    onClick={() => setShowCreateModal(false)}
                    >
                    取消
                    </button>
                    <button
                    className="bg-blue-500 text-white px-4 py-2 rounded"
                    onClick={triggerCreateRoom}
                    >
                    确定
                    </button>
                </div>
                </div>
            </div>
            }
            {showErrorModal &&
            <div
            className="fixed inset-0 bg-black/40 flex items-center justify-center z-50 "
            onClick={() => clearErrorModal()}
            >
                <div
                className="bg-white p-8 rounded shadow-lg min-w-[300px]"
                onClick={(e) => e.stopPropagation()}
                >
                <h2 className="text-lg mb-2">错误</h2>
                <p className='p-1'>{errorModalMsg}</p>
                <div className="flex justify-end space-x-2">
                    <button
                    className="bg-gray-300 px-4 py-2 mt-2 rounded hover:bg-gray-400 active:bg-gray-500"
                    onClick={() => clearErrorModal()}
                    >
                    关闭
                    </button>
                </div>
                </div>
            </div>
            }
        </>
    );
}