import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/room/delete
- method: POST
- argument:
interface RoomDeleteArgs {
    user: string;
    roomId: number;
}
- response: null （只要code为0即为成功）
*/

export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<null | Ty.UserNameRedirectArgs>>> {

    const cookieData = await Db.VerifyCookie(req.cookies);
    if('code' in cookieData) return NextResponse.json(cookieData);

    const { user, roomId } = await req.json() as Ty.RoomDeleteArgs;
    const checkResult = await Db.CheckUser(user, cookieData.userToken);
    if (!checkResult) return Db.IncorrectUserResponse(cookieData.userToken);

    const response = await Db.DeleteRoom({ user, roomId }, cookieData.userToken);
    return NextResponse.json(response);
}