import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/message/add
- method: POST
- argument:
interface MessageAddArgs {
    roomId: number;
    content: string;
    sender: string;
}
- response: null （只要code为0即为成功）
*/
export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<null | Ty.UserNameRedirectArgs>>> {

    const cookieData = await Db.VerifyCookie(req.cookies);
    if('code' in cookieData)return NextResponse.json(cookieData);

    const { roomId, content, sender } = await req.json() as Ty.MessageAddArgs;
    const checkResult = await Db.CheckUser(sender, cookieData.userToken);
    if (!checkResult) return Db.IncorrectUserResponse(cookieData.userToken);

    const response = await Db.AddMessage({ roomId, content, sender });
    return NextResponse.json(response);
}
