import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../../interface'
import * as Db from '../../../room-api';
import { RoomMessageGetUpdateArgsSchema } from '../../../interface-schema';

/*
- url: /api/room/message/getUpdate
- method: GET
- argument:
interface RoomMessageGetUpdateArgs {
    roomId: number;
    sinceMessageId: number;
}
- response:
interface RoomMessageGetUpdateRes {
    messages: Message[];
}
*/

export async function GET(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Ty.RoomMessageGetUpdateRes | null>>> {

    const cookieData = await Db.VerifyCookie(req.cookies);
    if('code' in cookieData) return NextResponse.json(cookieData);

    const Params: Record<string, string> = {};
    req.nextUrl.searchParams.forEach((value, key) => {Params[key] = value;});
    const parseResult = RoomMessageGetUpdateArgsSchema.safeParse(Params);
    if(!parseResult.success) return Db.IncorrectArgumentResponse(parseResult.error);

    const Args : Ty.RoomMessageGetUpdateArgs = parseResult.data;
    const result = await Db.UpdateMessageList(Args);
    return NextResponse.json(result);
}