'use client'

import { useRoom } from './room-context'
import { useRouter } from 'next/navigation';
import * as Ty from '../interface'
import * as Auth from '../api/login-interface'

export default function PageHeaderProvider() {

    const { username } = useRoom();
    const router = useRouter();

    const logout_Local = async () => {
      try {
        //URL : /api/auth/logout
        //method: POST
        const res = await fetch('/api/auth/logout', {
          method: 'POST',
        });
        if (!res.ok) {
            throw new Error('无法登出，错误码：' + res.status);
        }
        const data: Ty.BackendResponse<null> = await res.json();
        if (data.code !== 0) {
            throw new Error('无法登出，错误信息：' + data.message);
        }

        router.push('/');

      } catch (error) {
        console.error('Logout failed:', error);
      }
    };
    const logout_External = () => {
      router.push('/');
    };

    const logout = Ty.useLocalBackend ? logout_Local : logout_External;

    return (
        <header className="h-14 bg-white shadow flex items-center px-4 shrink-0">
        <h1 className="text-lg font-bold text-blue-600">XLAB聊天室</h1>
        <div className="ml-auto flex items-center space-x-4">
          <span className="text-sm text-gray-600">欢迎你，{username}</span>
          <button onClick={logout} className="text-sm text-gray-600 hover:underline">
            退出
          </button>
        </div>
      </header>
    );
}