import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../../interface'
import * as Db from '../../../room-api';
import { RoomMessageListArgsSchema } from '../../../interface-schema';

/*
- url: /api/room/message/list
- method: GET
- argument:
interface RoomMessageListArgs {
    roomId: number;
}
- response:
interface RoomMessageListRes {
    messages: Message[];
}
*/
export async function GET(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Ty.RoomMessageListRes | null>>> {
    const cookieData = await Db.VerifyCookie(req.cookies);
    if('code' in cookieData) return NextResponse.json(cookieData);

    const Params: Record<string, string> = {};
    req.nextUrl.searchParams.forEach((value, key) => {Params[key] = value;});
    const parseResult = RoomMessageListArgsSchema.safeParse(Params);
    if(!parseResult.success) return Db.IncorrectArgumentResponse(parseResult.error);

    const Args : Ty.RoomMessageListArgs = parseResult.data;

    const response = await Db.GetMessageList(Args);
    return NextResponse.json(response);
}
