'use client';
import { useEffect, useState } from 'react';
import { useRouter } from 'next/navigation';
import { useLocalBackend } from '../interface';
import * as Auth from '../api/login-interface';
import * as Ty from '../interface';

export default function AutoLoginProvider() {

    const router = useRouter();

    const autoLogin = async () => {
        try {
            /*
            - url: /api/auth/autoLogin
            - method: POST
            */
            const res = await fetch(`${Ty.urlPrefix}/api/auth/autoLogin`, {
                method: 'POST',
            });
            if (!res.ok) throw new Error('自动登录失败：' + res.status);
            const data: Ty.BackendResponse<Auth.LoginResult> = await res.json();
            if (data.code !== 0) return;
            router.push(`/chat?username=${encodeURIComponent(data.data.user)}`);
        } catch (error) {
            console.error(error);
            alert(error.message);
        }
    };

    useEffect(() => {
        autoLogin();
    }, [router]);

    return <></>;
}