import {z} from 'zod';

export const RoomAddArgsSchema = z.object({
    user: z.string().min(2).max(100),
    roomName: z.string().min(1).max(100)
});

export const RoomDeleteArgsSchema = z.object({
    user: z.string().min(2).max(100),
    roomId: z.number()
});

export const maxMessageLength = 1000;

export const MessageAddArgsSchema = z.object({
    sender: z.string().min(2).max(100),
    roomId: z.number(),
    content: z.string().min(1).max(maxMessageLength)
});

export const RoomMessageListArgsSchema = z.object({
    roomId: z.coerce.number().int()
});

export const RoomMessageGetUpdateArgsSchema = z.object({
    roomId: z.coerce.number().int(),
    sinceMessageId: z.coerce.number().int()
});
