import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';
import * as Auth from '../../login-interface';

/*
- url: /api/auth/startSession
- method: GET
*/
export async function GET(_req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Auth.Session | null>>> {
    
    const result = await Db.StartAuthSession();

    return NextResponse.json(result);
}