'use client'

import { useEffect } from 'react';
import { redirect } from 'next/navigation';
import { useRoom } from './room-context'
import { useLocalBackend, urlPrefix, BackendResponse } from '../interface';
import * as Auth from '../api/login-interface';


function UsernameCheck_External() {
  const { username } = useRoom()
  useEffect(() => {
    if (!username) {
      redirect('/'); 
    }
  }, [username]);

  if (!username) return null;

  return null;
}

function UsernameCheck_Local() {
  //URL /api/auth/loggedIn
  //invalidUserErrorCode
  //reloginErrorCode
  //incorrectUserName
  const { username, setUsername, setAfterErrorModalEvent, triggerErrorModal } = useRoom();

  const checkLogin = async () => {
    try{
      const Args : Auth.LoggedInArgs = { user: username };

      const res = await fetch(`${urlPrefix}/api/auth/loggedIn`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(Args),
      });

      const data : BackendResponse<Auth.LoggedInResult | null> = await res.json();

      if (data.code === Auth.incorrectUserName) {
        const result = data.data as Auth.LoggedInResult;
        setUsername(result.user);
        setAfterErrorModalEvent(() => {
          window.location.href = `/chat?username=${encodeURIComponent(result.user)}`;
        });
        throw new Error(data.message);
      } 
      else if (data.code !== 0) {
        setUsername('');
        setAfterErrorModalEvent(() => {
          window.location.href = `/`;
        });
        throw new Error(`登录错误: ${data.message}`);
      }
    } catch (error) {
      console.error(error);
      triggerErrorModal((error as Error).message);
    }
  };

  //check every 5 minutes
  useEffect(() => {
    checkLogin();

    const interval = setInterval(() => {
      checkLogin();
    }, 5 * 60 * 1000); // 5 minutes

    return () => clearInterval(interval);
  }, []);

  return null;
}

const UsernameCheckFn = useLocalBackend ? UsernameCheck_Local : UsernameCheck_External;

export default function UsernameCheck() {
  UsernameCheckFn();
  return null;
}