import RoomListProvider from './room-list';
import RoomHeaderProvider from './current-room';
import RoomMessageProvider from './room-message';
import SendMessageProvider from './send-message';
import UsernameCheck from './username-check';
import PageHeaderProvider from './header'
import ConfirmModalProvider from './confirm-modal';
import { RoomProvider } from './room-context'
import { Suspense } from 'react';

export default function Home() {

  return (
    <Suspense fallback={<div>Loading...</div>}>
      <RoomProvider>
        <UsernameCheck />
        <ConfirmModalProvider />
        <div className="bg-gray-100 flex-col flex h-screen">
          <PageHeaderProvider />
          <div className="flex flex-1 overflow-hidden">
            <div className="w-1/4 bg-white p-4 overflow-y-auto">
            <h2 className="text-lg font-bold mb-4">房间列表</h2>
            <RoomListProvider />
          </div>
          <div className="w-3/4 bg-gray-100 p-4">
                <RoomHeaderProvider />
                <RoomMessageProvider />
                <SendMessageProvider />
          </div>
          </div>
        </div>
      </RoomProvider>
    </Suspense>
  );
}
