import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/room/add
- method: POST
- argument:
interface RoomAddArgs {
    user: string;
    roomName: string;
}
- response:
interface RoomAddRes {
    roomId: number;
}
*/
export async function POST(req: NextRequest) {
    const { user, roomName }: Ty.RoomAddArgs = await req.json();
    const response = await Db.AddRoom({ user, roomName });
    return NextResponse.json(response);
}