import {z} from 'zod';

export interface Session {
    sessionId: string;
}

export interface AuthArgs {
    sessionId: string;
    username: string;
    password: string;
    userAgent: string | null;
    userIP: string | null;
}

export interface LoginCookieData {
    userToken: string;
    authToken: string;
}

export interface LoginResult {
    user: string;
    cookie: LoginCookieData;
}

export interface RegisterResult {
    user: string;
}

export interface AutoLoginArgs {
    cookie: LoginCookieData;
}

export const cookieSchema = z.object({
    userToken: z.string().nullable(),
    authToken: z.string().nullable()
});

export const minPasswordLength = 8;
export const maxPasswordLength = 100;

export const authArgsSchema = z.object({
    sessionId: z.string(),
    username: z.string().min(2).max(100),
    password: z.string().min(minPasswordLength).max(maxPasswordLength),
    userAgent: z.string().max(200).nullable(),
    userIP: z.string().max(100).nullable()
});

export const reloginErrorCode = 1919810;
export const invalidUserErrorCode = 8848;
export const notAuthorizedToDeleteRoomErrorCode = 2;

