
/*
======================================
===============后端选择===============
======================================
*/
const useLocalBackend : boolean = true;
/*
======================================
======================================
======================================
*/


export const urlPrefix = useLocalBackend ? '' : 'https://chatroom.zjuxlab.com'

export interface BackendResponse<T> {
    code: number;
    message: string;
    data: T;
}

export interface Message {
    messageId: number;  // 消息 id
    roomId: number;     // 房间 id
    sender: string;     // 发送人的 username
    content: string;    // 消息内容
    time: number;  // 消息发送时间戳
}

export interface RoomPreviewInfo {
    roomId: number;
    roomName: string;
    lastMessage: Message | null;
}

export interface RoomAddArgs {
    user: string;
    roomName: string;
}

export interface RoomAddResult {
    roomId: number;
}

export interface RoomListRes {
    rooms: RoomPreviewInfo[];
}

export interface RoomDeleteArgs {
    user: string;
    roomId: number;
}

export interface MessageAddArgs {
    roomId: number;
    content: string;
    sender: string;
}

export interface RoomMessageListArgs {
    roomId: number;
}

export interface RoomMessageListRes {
    messages: Message[];
}

export interface RoomMessageGetUpdateArgs {
    roomId: number;
    sinceMessageId: number;
}

export interface RoomMessageGetUpdateRes {
    messages: Message[];
}

export interface RoomMessageGetUpdateArgs {
    roomId: number;
    sinceMessageId: number;
}

export interface RoomMessageGetUpdateRes {
    messages: Message[];
}