'use client'
import { createContext, useContext, useState, ReactNode, useCallback } from 'react'
import * as Ty from '../interface'
import { useSearchParams} from 'next/navigation';

interface RoomCtxValue {
  currentRoomInfo: Ty.RoomPreviewInfo | null
  setCurrentRoomInfo: (r: Ty.RoomPreviewInfo | null) => void
  username: string;
  setUsername: (u: string) => void;
  msgVersion: number;
  triggerRefresh: () => void;
  showCreateModal: boolean;
  setShowCreateModal: (show: boolean) => void;
  showErrorModal: boolean;
  setShowErrorModal: (error: boolean) => void;
  errorModalMsg: string;
  triggerErrorModal: (msg: string) => void;
  newRoomName: string;
  setNewRoomName: (name: string) => void;
  createRoomVersion: number;
  triggerCreateRoom: () => void;
}

const RoomContext = createContext<RoomCtxValue>({} as RoomCtxValue)

export function RoomProvider({ children }: { children: ReactNode }) {

  /* 这段后面换成登录 */
  const searchParams = useSearchParams();
  const userName = searchParams.get('username')?.trim() || '';
  
  const [currentRoomInfo, setCurrentRoomInfo] = useState<Ty.RoomPreviewInfo | null>(null)
  const [username, setUsername] = useState<string>(userName);
  const [msgVersion, setMsgVersion] = useState(0);
  const [showCreateModal, setShowCreateModal] = useState(false);
  const [newRoomName, setNewRoomName] = useState('');
  const [createRoomVersion, setCreateRoomVersion] = useState(0);
  const [showErrorModal, setShowErrorModal] = useState(false);
  const [errorModalMsg, setErrorModalMsg] = useState('');

  const triggerRefresh = useCallback(() => setMsgVersion(v => v + 1), []);
  const triggerCreateRoom = useCallback(() => setCreateRoomVersion(v => v + 1), []);
  const triggerErrorModal = useCallback((msg: string) => {
    setErrorModalMsg(msg);
    setShowErrorModal(true);
  }, []);

  return (
    <RoomContext.Provider value={{ 
      currentRoomInfo, 
      setCurrentRoomInfo, 
      username, 
      setUsername, 
      msgVersion, 
      triggerRefresh,
      showCreateModal,
      setShowCreateModal,
      showErrorModal,
      setShowErrorModal,
      errorModalMsg,
      triggerErrorModal,
      newRoomName,
      setNewRoomName,
      createRoomVersion,
      triggerCreateRoom
      }}>
      {children}
    </RoomContext.Provider>
  )
}

export const useRoom = () => useContext(RoomContext)