'use client'

import { useRoom } from './room-context'
import { useRouter } from 'next/navigation';

export default function PageHeaderProvider() {

    const { username } = useRoom();
    const router = useRouter();

    const logout = () => {
      /* 这段后面换成登录 */
      router.push('/');
    };

    return (
        <header className="h-14 bg-white shadow flex items-center px-4 shrink-0">
        <h1 className="text-lg font-bold text-blue-600">XLAB聊天室</h1>
        <div className="ml-auto flex items-center space-x-4">
          <span className="text-sm text-gray-600">欢迎你，{username}</span>
          <button onClick={logout} className="text-sm text-gray-600 hover:underline">
            退出
          </button>
        </div>
      </header>
    );
}