import * as Ty from '../interface'

export interface RoomInfo extends Ty.RoomPreviewInfo {
    creator: string;
}

export let State = {
    maxRoomId: 2 as number,
    maxMessageId: 3 as number,
    fakeRooms: [
        {
            roomId: 1,
            roomName: '房间1',
            lastMessage: null,
            creator: '用户1'
        },
        {
            roomId: 2,
            roomName: '房间2',
            lastMessage: null,
            creator: '用户2'
        }
    ] as RoomInfo[],
    fakeMsg: [
        {
            messageId: 1,
            roomId: 1,
            sender: '用户1',
            content: '你好',
            time: Date.now()
        },
        {
            messageId: 2,
            roomId: 1,
            sender: '用户2',
            content: '你好啊',
            time: Date.now()
        },
        {
            messageId: 3,
            roomId: 2,
            sender: '用户1',
            content: '房间2的消息',
            time: Date.now()
        }
    ] as Ty.Message[],
}
