import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../../interface'
import * as Db from '../../../room-api';

/*
- url: /api/room/message/list
- method: GET
- argument:
interface RoomMessageListArgs {
    roomId: number;
}
- response:
interface RoomMessageListRes {
    messages: Message[];
}
*/
export async function GET(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Ty.RoomMessageListRes>>> {
    const Params = req.nextUrl.searchParams;
    const response = await Db.GetMessageList({ roomId: Number(Params.get('roomId')) });
    return NextResponse.json(response);
}
