import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../../interface'
import * as Db from '../../../room-api';

/*
- url: /api/room/message/getUpdate
- method: GET
- argument:
interface RoomMessageGetUpdateArgs {
    roomId: number;
    sinceMessageId: number;
}
- response:
interface RoomMessageGetUpdateRes {
    messages: Message[];
}
*/

export async function GET(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<Ty.RoomMessageGetUpdateRes>>> {
    const Params = req.nextUrl.searchParams;
    const result = await Db.UpdateMessageList({
        roomId: Number(Params.get('roomId')),
        sinceMessageId: Number(Params.get('sinceMessageId'))
    });
    return NextResponse.json(result);
}