import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/room/list
- method: GET
- argument: null
- response:
interface RoomListRes {
    rooms: RoomPreviewInfo[];
}
*/
export async function GET(req: NextRequest) : 
Promise<NextResponse<Ty.BackendResponse<Ty.RoomListRes>>> {
    const response = await Db.GetRoomList();
    return NextResponse.json(response);
}