import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/room/delete
- method: POST
- argument:
interface RoomDeleteArgs {
    user: string;
    roomId: number;
}
- response: null （只要code为0即为成功）
*/

export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<null>>> {
    const { user, roomId } = await req.json() as Ty.RoomDeleteArgs;
    const response = await Db.DeleteRoom({ user, roomId });
    return NextResponse.json(response);
}