import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../interface'
import {RoomInfo, State} from './tmp-state'

export async function MakeError(message: string, code: number = 1): Promise<NextResponse<Ty.BackendResponse<null>>> {
    return NextResponse.json({
        code,
        message,
        data: null
    });
}

export async function GetRoomList(): Promise<Ty.BackendResponse<Ty.RoomListRes>> {
    console.log('获取到的房间列表:', State.fakeRooms as Ty.RoomPreviewInfo[]);
    return {
        code: 0,
        message: '房间获取成功',
        data: {
            rooms: State.fakeRooms as Ty.RoomPreviewInfo[]
        }
    };
}

export async function AddRoom(data: Ty.RoomAddArgs): Promise<Ty.BackendResponse<Ty.RoomAddResult>> {
    const newRoom: RoomInfo = {
        roomId: State.maxRoomId + 1,
        roomName: data.roomName,
        lastMessage: null,
        creator: data.user
    };
    State.fakeRooms = [...State.fakeRooms, newRoom];
    console.log('当前房间列表:', State.fakeRooms);
    State.maxRoomId++;
    return {
        code: 0,
        message: '房间创建成功',
        data: {
            roomId: newRoom.roomId
        }
    };
}

export async function GetMessageList(data : Ty.RoomMessageListArgs): Promise<Ty.BackendResponse<Ty.RoomMessageListRes>> {
    const { roomId } = data;
    const messages = State.fakeMsg.filter(msg => msg.roomId === roomId);
    return {
        code: 0,
        message: '消息获取成功',
        data: {
            messages
        }
    };
}

export async function UpdateMessageList(data: Ty.RoomMessageGetUpdateArgs): Promise<Ty.BackendResponse<Ty.RoomMessageGetUpdateRes>> {
    const { roomId, sinceMessageId } = data;
    const messages = State.fakeMsg.filter(msg => msg.roomId === roomId && msg.messageId > sinceMessageId);
    return {
        code: 0,
        message: '消息更新成功',
        data: {
            messages
        }
    };
}

//后续需要补上房间建立者和删除者不同的无权限错误
export async function DeleteRoom(data: Ty.RoomDeleteArgs): Promise<Ty.BackendResponse<null>> {
    const { user, roomId } = data;
    State.fakeRooms = State.fakeRooms.filter(room => room.roomId !== roomId);
    State.fakeMsg = State.fakeMsg.filter(msg => msg.roomId !== roomId);
    return {
        code: 0,
        message: '房间删除成功',
        data: null
    };
}

export async function AddMessage(data: Ty.MessageAddArgs): Promise<Ty.BackendResponse<null>> {
    const { roomId, sender, content } = data;
    const newMessage: Ty.Message = {
        messageId: State.maxMessageId + 1,
        roomId,
        sender,
        content,
        time: Date.now()
    };
    State.fakeMsg = [...State.fakeMsg, newMessage];
    State.maxMessageId++;
    return {
        code: 0,
        message: '消息发送成功',
        data: null
    };
}