import { NextRequest, NextResponse } from 'next/server';
import * as Ty from '../../../interface'
import * as Db from '../../room-api';

/*
- url: /api/message/add
- method: POST
- argument:
interface MessageAddArgs {
    roomId: number;
    content: string;
    sender: string;
}
- response: null （只要code为0即为成功）
*/
export async function POST(req: NextRequest): Promise<NextResponse<Ty.BackendResponse<null>>> {
    const { roomId, content, sender } = await req.json() as Ty.MessageAddArgs;
    const response = await Db.AddMessage({ roomId, content, sender });
    return NextResponse.json(response);
}
